#include "matrix.h"
#include "hardware.h"

uint8_t activeCol;
//uint8_t bitmap[8] = {0xFF, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0xFF};
extern uint8_t bitMap[];
void Matrix_setup(void)
{
	uint8_t i;
	PTB->PSOR = HCF_D;				// turn off all columns
	for (i=0; i<8; i++)
	{
		PTB->PSOR = HCF_CLK;		// clock in zeros into HCF4094
		__NOP();
		__NOP();
		PTB->PCOR = HCF_CLK;	
	}
	activeCol = 8;
}

void Matrix_retrace()				// will be called automatically from main
{
	uint8_t val1, val2;
	SPI_send(0);					// turn off active matrix column
	PTA->PSOR = TLC_LE;
	__NOP();
	__NOP();
	PTA->PCOR = TLC_LE;				// prepare new data to clock into HCF4094
	if (activeCol == 8)
	{	
		PTB->PCOR = HCF_D;
		activeCol = 0;
	}
	else
		PTB->PSOR = HCF_D;
	
	PTB->PSOR = HCF_CLK;			// turn on the next column
	__NOP();
	__NOP();
	PTB->PCOR = HCF_CLK;
	
	val1 = bitMap[(activeCol+4) & 0x07];	// transform column data according to
	val2 = val1 & 0x0F;				// PCB layout
	val2 += (val1 & 0x80) >> 3;
	val2 += (val1 & 0x40) >> 1;
	val2 += (val1 & 0x20) << 1;
	val2 += (val1 & 0x10) << 3;
	SPI_send(val2);
	PTA->PSOR = TLC_LE;				// load next column with data
	__NOP();
	__NOP();
	PTA->PCOR = TLC_LE;	
	activeCol++;
}

